import { html, css } from 'lit'
import { t } from '../core/translate'

import '../ui/qrcg-box'

import { QRCGAccountPage } from './qrcg-account-page'

class QRCGEmailVerified extends QRCGAccountPage {
    static get styles() {
        return [
            super.styles,
            css`
                :host {
                    user-select: none;
                    -webkit-user-select: none;
                }

                p {
                    line-height: 1.8;
                }

                a {
                    color: var(--primary-0);
                }
            `,
        ]
    }

    constructor() {
        super()
    }

    renderContent() {
        return html`
            <h1>${t`Your email has been verified`}</h1>

            <p>${t`You can login to your account`}</p>

            <div>
                <a href="/account/login">${t`Login`}</a>
            </div>
        `
    }
}

window.customElements.define('qrcg-email-verified', QRCGEmailVerified)
