import { html } from 'lit'

import '../ui/qrcg-box'
import '../ui/qrcg-input'
import '../ui/qrcg-button'
import '../ui/qrcg-form'
import '../ui/qrcg-link'
import { post } from '../core/api'

import { QRCGAccountPage } from './qrcg-account-page'

import { t } from '../core/translate'

class QRCGForgotPassword extends QRCGAccountPage {
    static get properties() {
        return {
            data: {},
            success: {
                type: Boolean,
                state: true,
            },
        }
    }

    constructor() {
        super()

        this.data = {
            email: '',
        }

        this.success = false
    }

    async submitForm() {
        try {
            await this.api.call(() => post('forgot-password', this.data))

            this.success = true
        } catch (e) {
            console.error(e)
        }
    }

    renderSuccess() {
        return html`
            <p>
                ${t`If we found your email, we have sent you the reset instructions.`}
            </p>
        `
    }

    renderInitialState() {
        return html`
            <p>${t`Enter your email to send you the reset instructions.`}</p>

            <qrcg-form>
                <qrcg-input
                    autofocus
                    name="email"
                    placeholder="email@provider.com"
                >
                    ${t`Email`}
                </qrcg-input>

                <qrcg-button type="submit">${t`Submit`}</qrcg-button>
            </qrcg-form>
        `
    }

    renderContent() {
        return html`
            <h1>${t`Password reset`}</h1>

            ${this.success ? this.renderSuccess() : this.renderInitialState()}
        `
    }
}

window.customElements.define('qrcg-forgot-password', QRCGForgotPassword)
