import { css, html } from 'lit'

import '../ui/qrcg-box'
import '../ui/qrcg-input'
import '../ui/qrcg-button'
import '../ui/qrcg-form'
import '../ui/qrcg-link'
import { post } from '../core/api'
import { push } from '../core/qrcg-router'
import { storeToken } from '../core/auth'
import { QRCGAccountPage } from './qrcg-account-page'
import { Config } from '../core/qrcg-config'

import { QRCGLogin } from './qrcg-login'
import { showToast } from '../ui/qrcg-toast'
import { t } from '../core/translate'

class QRCGSignUp extends QRCGAccountPage {
    static get styles() {
        return [
            super.styles,
            css`
                .disabled-message {
                    font-weight: normal;
                    padding: 1rem;
                    background-color: var(--gray-0);
                    font-size: 0.8rem;
                    border-radius: 0;
                    margin-bottom: 1rem;
                }
            `,
        ]
    }
    constructor() {
        super()

        this.data = {
            name: '',
            email: '',
            password: '',
            password_confirmation: '',
        }
    }

    async submitForm() {
        try {
            const { token } = await this.api.call(() =>
                post('register', this.data)
            )

            storeToken(token)

            if (Config.get('app.email_verification_after_sign_up'))
                push('/account/verify-email')
            else {
                await QRCGLogin.login(this.data)
                showToast('Account created successfully')
            }
        } catch (e) {
            console.error(e)
        }
    }

    renderTitle() {
        return html`<h1>${t`Sign up`}</h1>`
    }

    renderDisabledForm() {
        return html`
            <div class="disabled-message">
                ${t`New registrations are disabled.`}
            </div>
        `
    }

    renderForm() {
        if (Config.get('app.new_user_registration') === 'disabled') {
            return this.renderDisabledForm()
        }

        return html`
            <qrcg-input autofocus name="name" placeholder=${t`your name`}>
                ${t`Name`}
            </qrcg-input>

            <qrcg-input name="email" placeholder=${t`email@provider.com`}>
                ${t`Email`}
            </qrcg-input>

            <qrcg-input
                name="password"
                type="password"
                placeholder=${t`between 6 and 8 charachters`}
            >
                ${t`Password`}
            </qrcg-input>

            <qrcg-input
                name="password_confirmation"
                type="password"
                placeholder=${t`confirm your password`}
            >
                ${t`Password confirmation`}
            </qrcg-input>

            <qrcg-button type="submit">${t`Sign up`}</qrcg-button>
        `
    }
}

window.customElements.define('qrcg-sign-up', QRCGSignUp)
