import { css, html } from 'lit'

import { userHomePage } from '../core/auth'

import { t } from '../core/translate'

import { QrcgCheckoutPage } from './qrcg-checkout-page'

export class QrcgCheckoutOfflinePaymentReceived extends QrcgCheckoutPage {
    static get styles() {
        return [
            ...super.styles,
            css`
                .button-container {
                    display: flex;
                }
            `,
        ]
    }
    renderTitle() {
        return t`Your Payment Details Are Received`
    }

    renderPage() {
        return html`
            <p>
                ${t`We have received your payment proof, we will notify you once your payment is confirmed from our end.`}
            </p>

            <div class="button-container">
                <qrcg-button href=${userHomePage()}>
                    ${t`Go to dashboard`}
                </qrcg-button>
            </div>
        `
    }
}

customElements.define(
    'qrcg-checkout-offline-payment-received',
    QrcgCheckoutOfflinePaymentReceived
)
