import { mdiHelpCircle, mdiLifebuoy } from '@mdi/js'
import { LitElement, html, css } from 'lit'
import { Config } from '../core/qrcg-config'

export class QrcgBuyToolbar extends LitElement {
    static instances = []

    static styles = [
        css`
            :host {
                display: flex;
                padding: 0.8rem 1rem;
                background-color: black;
                color: white;
                justify-content: space-between;
                align-items: center;
                font-size: 0.8rem;
            }

            :host(.hide) {
                display: none;
            }

            .button {
                display: block;
                background-color: white;
                color: black;
                padding: 0.25rem 0.5rem;
                border-radius: 0.2rem;
                text-decoration: none;
                user-select: none;
                -webkit-user-select: none;
                touch-action: manipulation;
            }

            .button:hover {
                background-color: var(--primary-0);
                color: white;
            }

            .link {
                color: white;
                text-decoration: none;
                margin-right: 1rem;
                display: flex;
                align-items: center;
            }

            .link:hover {
                text-decoration: underline;
            }

            .link {
                display: none;
            }

            @media (min-width: 800px) {
                .link {
                    display: flex;
                }
            }

            qrcg-icon {
                margin-right: 0.5rem;
            }

            .actions {
                display: flex;
                align-items: center;
            }
        `,
    ]

    constructor() {
        super()

        if (!this.constructor.shouldShow()) {
            this.classList.add('hide')
        }
    }

    static shouldShow() {
        return Config.get('app.env') == 'demo'
    }

    connectedCallback() {
        super.connectedCallback()
        this.constructor.instances.push(this)
    }

    disconnectedCallback() {
        super.disconnectedCallback()

        this.constructor.instances = this.constructor.instances.filter(
            (i) => i != this
        )
    }

    static get toolbarHeight() {
        if (!this.shouldShow() || !this.instances[0]) {
            return 0
        }

        return this.instances[0].clientHeight
    }

    render() {
        return html`
            <div>Quick Code - QR Code Generator</div>
            <div class="actions">
                <a
                    class="link"
                    href="https://docs.quickcode.digital"
                    target="_blank"
                >
                    <qrcg-icon mdi-icon=${mdiHelpCircle}></qrcg-icon>
                    Docs
                </a>
                <a
                    class="link"
                    href="https://quickcodesupport.atlassian.net/servicedesk/customer/portal/3?envato_item_id=37713672"
                    target="_blank"
                >
                    <qrcg-icon mdi-icon=${mdiLifebuoy}></qrcg-icon>
                    Customer Support
                </a>
                <a
                    rel="noopener noreferrer"
                    class="button"
                    href="https://codecanyon.net/item/quick-code-qr-code-generator-saas/37713672"
                    >Buy now</a
                >
            </div>
        `
    }
}
customElements.define('qrcg-buy-toolbar', QrcgBuyToolbar)
