import { LitElement, css } from 'lit'
import { isEmpty } from '../core/helpers'

import { Config } from '../core/qrcg-config'

export class QrcgFrontendCustomUrlRouter extends LitElement {
    static styles = [
        css`
            :host {
                display: none;
            }
        `,
    ]

    connectedCallback() {
        super.connectedCallback()

        window.addEventListener(
            'qrcg-router:location-will-change',
            this.onLocationWillChange
        )
    }

    disconnectedCallback() {
        super.disconnectedCallback()

        window.removeEventListener(
            'qrcg-router:location-will-change',
            this.onLocationWillChange
        )
    }

    href(path) {
        const a = document.createElement('a')

        a.href = path

        const href = a.href

        a.remove()

        return href
    }

    onLocationWillChange = (e) => {
        if (!this.url) return

        if (this.href(e.detail.url) === this.href('/')) {
            e.preventDefault()

            window.location = this.url
        }
    }

    get url() {
        return this.constructor.url
    }

    static get url() {
        return !isEmpty(Config.get('app.frontend_custom_url'))
            ? Config.get('app.frontend_custom_url')
            : null
    }

    render() {
        return null
    }

    static async boot() {
        while (!document.body) {
            await new Promise((resolve) => setTimeout(resolve, 50))
        }

        document.body.appendChild(new QrcgFrontendCustomUrlRouter())
    }
}

customElements.define(
    'qrcg-frontend-custom-url-router',
    QrcgFrontendCustomUrlRouter
)

QrcgFrontendCustomUrlRouter.boot()
