import { isFunction, isEmpty } from './helpers'

export class QRCGFormController {
    host

    constructor(host) {
        this.host = host
        host.addController(this)
    }

    async hostConnected() {
        await new Promise((resolve) => setTimeout(resolve, 0))

        this.host.addEventListener('on-input', (e) => {
            this.host.data = {
                ...this.host.data,
                [e.detail.name]: e.detail.value,
            }
        })

        this.host.renderRoot
            .querySelector('qrcg-button[type=submit]')
            ?.addEventListener('click', () => {
                this.host.renderRoot.querySelector('qrcg-form').submit()
            })

        this.host.renderRoot
            .querySelector('qrcg-form')
            ?.addEventListener('on-submit', (e) => {
                e.stopImmediatePropagation()

                if (isFunction(this.host.submitForm)) {
                    this.host.submitForm()
                }

                this.fireSubmit()
            })
    }

    async hostUpdate() {
        await new Promise((resolve) => setTimeout(resolve, 0))

        const elems = this.host.renderRoot.querySelectorAll('[name]')

        if (isEmpty(this.host.data)) return

        elems.forEach((elem) => {
            elem.value = this.host.data[elem.name]
        })
    }

    fireSubmit() {
        this.host.dispatchEvent(
            new CustomEvent('on-submit', {
                bubbles: true,
                composed: true,
                detail: {
                    data: this.host.data,
                },
            })
        )
    }
}
