import { showNotice } from '../../dashboard/qrcg-dashboard-notice'
import { isSuperAdmin, loadUser } from '../auth'
import { showSubscriptionModal } from './modal'
import { STATUS_ACTIVE, STATUS_PENDING_PAYMENT } from './statuses'

export function currentSubscription() {
    const user = loadUser()

    // Pending payment subscription(s) is just ignored

    return user.subscriptions.find((s) => {
        return s.statuses[0].status !== STATUS_PENDING_PAYMENT
    })
}

export function currentPlan() {
    return currentSubscription()?.subscription_plan
}

export function trialSubscription() {
    const user = loadUser()

    return user.subscriptions.find((s) => s.subscription_plan.is_trial)
}

export function onTrial() {
    return currentSubscription().subscription_plan.is_trial
}

export function requiresSubscription(url) {
    return !!url.match(/qrcodes\/new|qrcodes\/edit/)
}

/**
 * Determines if the current user has active subscription plan
 * @returns {Boolean}
 */
export function hasActiveSubscription() {
    const user = loadUser()

    const activeSubscription = user.subscriptions.find(
        (s) => s.statuses[0].status === STATUS_ACTIVE
    )

    return !!activeSubscription
}

export function getTrialRemainingDays() {
    const subscription = trialSubscription()

    const subscriptionStartDate = new Date(subscription.created_at)

    const trialDays = subscription.subscription_plan.trial_days

    const spanDays = Math.floor(
        (Date.now() - subscriptionStartDate) / (1000 * 3600 * 24)
    )

    return trialDays - spanDays
}

export function showExpirationAction() {
    showSubscriptionModal()
}

export function currentSubscriptionIsPendingPayment() {
    return (
        currentSubscriptionStatus() === STATUS_PENDING_PAYMENT &&
        !hasActiveSubscription()
    )
}

export function currentSubscriptionStatus() {
    return currentSubscription().statuses[0].status
}

export async function showSubsciptionNotice({
    message,
    link = '/pricing-plans',
}) {
    await new Promise((resolve) => setTimeout(resolve, 0))

    showNotice({ message, link })
}

export function getPlanRemainingDays() {
    const subscription = currentSubscription()

    const subscriptionStartDate = new Date(subscription.created_at)

    const plan = currentPlan()

    if (plan?.frequency === 'ONE_TIME') {
        return Number.MAX_SAFE_INTEGER
    }

    const planDays = 365 // One year

    const remainingDays = Math.floor(
        (Date.now() - subscriptionStartDate) / (1000 * 3600 * 24)
    )

    return planDays - remainingDays
}

export const EXPIRING_SOON_DAYS = 3

export function featureAllowed(feature) {
    if (isSuperAdmin()) return true

    const plan = currentPlan()

    return !!plan.features?.find((f) => f == feature)
}
