import { html } from 'lit'
import { t } from '../core/translate'

import { QrcgDashboardForm } from '../dashboard/qrcg-dashboard-form'

export class QrcgCurrencyForm extends QrcgDashboardForm {
    constructor() {
        super({
            apiBaseRoute: 'currencies',
        })
    }

    renderFormFields() {
        return html`
            <qrcg-input name="name" placeholder=${t`Currency name`}
                >${t`Name`}</qrcg-input
            >
            <qrcg-input name="currency_code" placeholder=${t`Currency code`}
                >${t`Currency Code`}</qrcg-input
            >
            <qrcg-input name="symbol" placeholder=${t`Symbol`}
                >${t`Symbol`}</qrcg-input
            >
        `
    }
}
customElements.define('qrcg-currency-form', QrcgCurrencyForm)
