import { LitElement, html, css } from 'lit'

import './qrcg-dashboard-sidebar'

import './qrcg-dashboard-header'

import { state } from './state'

import { observeState } from 'lit-element-state'

import { isEmpty, styled } from '../core/helpers'

import './qrcg-dashboard-notice'

import './qrcg-dashboard-breadcrumbs'

import './qrcg-dashboard-sidebar-toggle'

export class QRCGDashboardLayout extends observeState(LitElement) {
    static instances = []

    static get styles() {
        return css`
            :host {
                display: block;
                --dashboard-header-height: 3.5rem;
            }

            .sidebar-and-content {
                display: flex;
                position: relative;
                z-index: 0;
                /* height: 100%; */
            }

            .page-content {
                flex: 1;
                padding: 1rem;
                box-sizing: border-box;
                /* overflow-y: scroll; */
                /* height: calc(100vh - var(--dashboard-header-height)); */
            }

            qrcg-dashboard-breadcrumbs {
                margin-bottom: 1rem;
            }

            .content-header {
                display: flex;
            }

            .header-actions {
                margin-left: auto;
            }

            h1 {
                font-weight: 300;
                margin: 0 0 1rem 0;
            }

            .page-content > qrcg-box {
                padding: 1rem;
            }

            .bottom-gap {
                padding: 12%;
            }
        `
    }

    constructor() {
        super()

        this.onCloseRequested = this.onCloseRequested.bind(this)

        this.onToggleRequested = this.onToggleRequested.bind(this)

        this.onOpenRequested = this.onOpenRequested.bind(this)
    }

    static get properties() {
        return {}
    }

    connectedCallback() {
        super.connectedCallback()

        document.addEventListener(
            'qrcg-dashboard-sidebar:request-toggle',
            this.onToggleRequested
        )

        document.addEventListener(
            'qrcg-dashboard-sidebar:request-close',
            this.onCloseRequested
        )

        document.addEventListener(
            'qrcg-dashboard-sidebar:request-open',
            this.onOpenRequested
        )

        this.attachGlobalStyles()

        this.constructor.instances.push(this)
    }

    disconnectedCallback() {
        super.disconnectedCallback()

        document.removeEventListener(
            'qrcg-dashboard-sidebar:request-toggle',
            this.onToggleRequested
        )

        document.removeEventListener(
            'qrcg-dashboard-sidebar:request-close',
            this.onCloseRequested
        )

        document.removeEventListener(
            'qrcg-dashboard-sidebar:request-open',
            this.onOpenRequested
        )

        this.detachGlobalStyles()

        this.constructor.instances = this.constructor.instances.filter(
            (i) => i !== this
        )
    }

    attachGlobalStyles() {
        const style = document.createElement('style')

        style.innerHTML = styled`
            html {
                /* overflow: hidden; */
                font-size: calc(14px + 6 * ((100vw - 320px) / 1240));
                scrollbar-width: none;

            }
            body {
                /* overflow: hidden; */
                
            }

            body::-webkit-scrollbar {
                display: none;
            }

            @media (min-width: 800px) {
                html {
                    font-size: calc(11px + 6 * ((100vw - 320px) / 1240));
                }
            }

            @media (min-width: 2300px) {
                html {
                    font-size: calc(10px + 6 * (130vw / 1240));
                }
            }
        `

        this.globalStyle = style

        document.head.appendChild(style)
    }

    detachGlobalStyles() {
        this.globalStyle.remove()
    }

    static get sidebarIsClosed() {
        return state.sidebarClosed
    }

    onCloseRequested() {
        state.sidebarClosed = true
    }

    onToggleRequested() {
        state.sidebarClosed = !state.sidebarClosed
    }

    onOpenRequested() {
        state.sidebarClosed = false
    }

    static get sidebarClosed() {
        if (isEmpty(this.instances)) return true

        return state.sidebarClosed
    }

    render() {
        return html`
            <qrcg-buy-toolbar></qrcg-buy-toolbar>
            <qrcg-dashboard-header></qrcg-dashboard-header>
            <div class="sidebar-and-content">
                <qrcg-dashboard-sidebar
                    .closed=${state.sidebarClosed}
                ></qrcg-dashboard-sidebar>
                <qrcg-dashboard-sidebar-toggle></qrcg-dashboard-sidebar-toggle>
                <div class="page-content">
                    <qrcg-dashboard-notice></qrcg-dashboard-notice>
                    <qrcg-dashboard-breadcrumbs></qrcg-dashboard-breadcrumbs>
                    <qrcg-box>
                        <div class="content-header">
                            <h1><slot name="title"></slot></h1>
                            <div class="header-actions">
                                <slot name="header-actions"></slot>
                            </div>
                        </div>
                        <div class="content">
                            <slot name="content"></slot>
                        </div>
                    </qrcg-box>
                </div>
            </div>
        `
    }
}

window.customElements.define('qrcg-dashboard-layout', QRCGDashboardLayout)
