import { LitElement, html, css } from 'lit'

export class QrcgDynamicVsStatic extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                margin: 2rem 0;
                line-height: 1.8;
                padding: 1rem;
            }

            .heading {
                text-align: center;
                margin-bottom: 2rem;
            }

            [name='title']::slotted(*) {
                color: var(--primary-0);
            }

            .grid {
                display: grid;

                grid-gap: 1rem;
            }

            @media (min-width: 850px) {
                .grid {
                    grid-template-columns: 1fr 1fr;
                }
            }

            [name='title-1']::slotted(*),
            [name='title-2']::slotted(*) {
                color: var(--primary-1);
                margin-top: 0;
                margin-bottom: 0;
            }

            [name='description-1']::slotted(*),
            [name='description-2']::slotted(*) {
                color: var(--gray-2);
            }

            .section {
                background-color: white;
                padding: 1rem;
            }

            .container {
                max-width: var(--container-max-width);
                margin: auto;
            }
        `,
    ]

    render() {
        return html`
            <div class="container">
                <div class="heading">
                    <slot name="title"></slot>
                    <slot name="description"></slot>
                </div>

                <div class="grid">
                    <qrcg-box class="section section-1">
                        <slot name="title-1"></slot>
                        <slot name="description-1"></slot>
                    </qrcg-box>

                    <qrcg-box class="section section-2">
                        <slot name="title-2"></slot>
                        <slot name="description-2"></slot>
                    </qrcg-box>
                </div>
            </div>
        `
    }
}
customElements.define('qrcg-dynamic-vs-static', QrcgDynamicVsStatic)
