import { css, html } from 'lit'
import { Config } from '../core/qrcg-config'
import { push } from '../core/qrcg-router'
import { QRCGInstallPage } from './qrcg-install-page'

export class QrcgInstallPurchaseCode extends QRCGInstallPage {
    static get styles() {
        return [
            super.styles,
            css`
                a {
                    color: var(--primary-0);
                }
            `,
        ]
    }

    connectedCallback() {
        super.connectedCallback()

        if (Config.get('qrcode.skip_install_step_1', Boolean)) {
            push(this.getNextLink())
        }
    }

    renderTitle() {
        return 'Purchase Code'
    }

    getBackLink() {
        return '/install'
    }

    getNextLink() {
        return '/install/app-details'
    }

    verifyLink() {
        return 'install/verify-purchase-code'
    }

    verificationFailedMessage() {
        return 'Invalid license key ...'
    }

    verificationSuccessMessage() {
        return 'License key accepted ...'
    }

    renderHelp() {
        return html`Please enter your license key.`
    }

    envVariables() {
        return [
            {
                key: 'ENVATO_PURCHASE_CODE',
                name: 'License Key',
                placeholder: '00000-0000-0000',
            },
        ]
    }
}

customElements.define('qrcg-install-purchase-code', QrcgInstallPurchaseCode)
