import { LitElement, html, css } from 'lit'

import '../core/qrcg-route'

import './qrcg-pricing-plans'

export class QrcgPricingPlansRouter extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    static async boot() {
        while (!document.body) {
            await new Promise((resolve) => setTimeout(resolve, 50))
        }

        const elem = new QrcgPricingPlansRouter()

        document.body.appendChild(elem)
    }

    render() {
        return html`
            <qrcg-route route="/pricing-plans">
                <template>
                    <qrcg-pricing-plans></qrcg-pricing-plans>
                </template>
            </qrcg-route>
        `
    }
}

customElements.define('qrcg-pricing-plans-router', QrcgPricingPlansRouter)

QrcgPricingPlansRouter.boot()
