import { html } from 'lit'

import { QrcgModal } from '../ui/qrcg-modal'

class QrcgQrcodePreviewModal extends QrcgModal {
    static get properties() {
        return {
            ...super.properties,
            title: {},
            qrcode: {},
            editText: {},
            statsText: {},
        }
    }

    renderTitle() {
        return this.title
    }

    renderBody() {
        return html`
            <qrcg-qrcode-image
                url=${this.qrcode?.getFileUrl('svg')}
                preview-on-dbl-click
            ></qrcg-qrcode-image>
        `
    }

    renderActions() {
        return html`
            <qrcg-button transparent modal-negative>
                ${this.negativeText}
            </qrcg-button>

            <qrcg-button modal-affirmative href=${this.qrcode?.getEditLink()}>
                ${this.editText}
            </qrcg-button>
        `
    }
}

export async function openPreviewModal({
    qrcode,
    title = 'Preview',
    editText = 'Edit',
    statsText = 'Stats',
    negativeText = 'Close',
} = {}) {
    const modal = new QrcgQrcodePreviewModal()

    modal.title = title

    modal.qrcode = qrcode

    modal.editText = editText

    modal.statsText = statsText

    modal.negativeText = negativeText

    document.body.appendChild(modal)

    await new Promise((resolve) => setTimeout(resolve, 10))

    return modal.open()
}

window.customElements.define(
    'qrcg-qrcode-preview-modal',
    QrcgQrcodePreviewModal
)
