import { html } from 'lit'

import { QrcgDashboardForm } from '../dashboard/qrcg-dashboard-form'

import '../common/qrcg-relation-select'
import { t } from '../core/translate'

export class QrcgSubscriptionForm extends QrcgDashboardForm {
    constructor() {
        super({
            apiBaseRoute: 'subscriptions',
        })
    }

    connectedCallback() {
        super.connectedCallback()
        this.addEventListener('api:success', this.onSuccess)
    }

    disconnectedCallback() {
        super.disconnectedCallback()
        this.removeEventListener('api:success', this.onSuccess)
    }

    onSuccess = (e) => {
        setTimeout(() => {
            const data = e.detail.response

            this.data = {
                ...this.data,
                subscription_status: data.statuses[0]?.status,
            }
        }, 0)
    }

    renderFormFields() {
        return html`
            <qrcg-relation-select name="user_id" endpoint="users">
                ${t`User`}
            </qrcg-relation-select>

            <qrcg-relation-select
                name="subscription_plan_id"
                endpoint="subscription-plans"
            >
                ${t`Subscription plan`}
            </qrcg-relation-select>

            <qrcg-relation-select
                name="subscription_status"
                endpoint="subscriptions/statuses"
            >
                ${t`Subscription status`}
            </qrcg-relation-select>
        `
    }
}
customElements.define('qrcg-subscription-form', QrcgSubscriptionForm)
