import { html } from 'lit'
import { isEmpty } from '../core/helpers'
import { t } from '../core/translate'
import { QRCGDashboardList } from '../dashboard/qrcg-dashboard-list'

export class QrcgSubscriptionList extends QRCGDashboardList {
    constructor() {
        super({
            baseRoute: 'subscriptions',
            singularRecordName: t('Subscription'),
            frontendFormUrl: null,
        })
    }

    static listColumns = [
        { key: 'id', label: 'ID', width: '2rem' },
        { key: 'user_display', label: 'User' },
        { key: 'subscription_plan.name', label: 'Plan' },
        { key: 'statuses[0].status', label: 'Status' },
        { key: 'created_at', label: 'Started at' },
        { key: 'actions', label: 'Actions' },
    ]

    cellContentRenderer(row, column) {
        switch (column.key) {
            case 'user_display':
                if (!isEmpty(row[column.key])) {
                    return row[column.key]
                }

                return html`<a href="/dashboard/users/edit/${row.user.id}"
                    >${row.user.name}</a
                >`

            default:
                return super.cellContentRenderer(row, column)
        }
    }

    searchPlaceholder() {
        return t('By anything')
    }

    renderDeleteRowLink() {
        return null
    }
}

customElements.define('qrcg-subscription-list', QrcgSubscriptionList)
