import { LitElement, html, css } from 'lit'

import '../core/qrcg-protected-route'

import './qrcg-system-status-page'

import './system-status-notice'

import './qrcg-system-settings-page'

export class QrcgSystemModuleRouter extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    static async boot() {
        while (!document.body) {
            await new Promise((resolve) => setTimeout(resolve, 50))
        }

        document.body.appendChild(new QrcgSystemModuleRouter())
    }

    render() {
        return html`
            <qrcg-protected-route
                route="/dashboard/system/status"
                permission="system.status"
            >
                <template>
                    <qrcg-system-status-page></qrcg-system-status-page>
                </template>
            </qrcg-protected-route>

            <qrcg-protected-route
                route="/dashboard/system/settings"
                permission="system.settings"
            >
                <template>
                    <qrcg-system-settings-page></qrcg-system-settings-page>
                </template>
            </qrcg-protected-route>

            <qrcg-redirect
                from="/dashboard/system$"
                to="/dashboard/system/status"
            ></qrcg-redirect>
        `
    }
}

customElements.define('qrcg-system-module-router', QrcgSystemModuleRouter)

QrcgSystemModuleRouter.boot()
