import { html, css } from 'lit'
import { t } from '../../core/translate'

import { QrcgSystemSettingsFormBase } from './base'

export class QrcgSystemSettingsFormIntegrations extends QrcgSystemSettingsFormBase {
    static styles = [
        super.styles,
        css`
            :host {
                display: block;
            }
        `,
    ]

    renderForm() {
        return html`
            <qrcg-input name="services.google.api_key">
                ${t`Google API Key`}
                <span slot="instructions">
                    ${t`Used in auto translation feature.`}
                </span>
            </qrcg-input>
        `
    }
}
customElements.define(
    'qrcg-system-settings-form-integrations',
    QrcgSystemSettingsFormIntegrations
)
