import { html, css } from 'lit'
import { t } from '../../core/translate'
import { qrTypes } from '../../models/qr-types'
import { QrcgSystemSettingsFormBase } from './base'

export class QrcgSystemSettingsFormPages extends QrcgSystemSettingsFormBase {
    static styles = [
        super.styles,
        css`
            :host {
                display: block;
            }
        `,
    ]

    renderQrTypesInputs() {
        return qrTypes.map(
            (type) => html`
                <qrcg-input
                    name="qrType.${type.id}.url"
                    placeholder="/${type.id}-qr-code-generator"
                >
                    ${t`Page URL of type: `} ${type.name}
                </qrcg-input>
            `
        )
    }

    renderForm() {
        return html`
            <section>
                <h2 class="section-title">${t`Dynamic Pages`}</h2>
                <qrcg-form-comment label="">
                    <p>
                        ${t`Dyanmic pages allow you to create pages manually and add your custom HTML code. Having ability to create pages is important for SEO.`}
                    </p>
                </qrcg-form-comment>

                ${this.renderQrTypesInputs()}
            </section>
        `
    }
}

customElements.define(
    'qrcg-system-settings-form-pages',
    QrcgSystemSettingsFormPages
)
