import { mdiRefresh } from '@mdi/js'
import { LitElement, html, css } from 'lit'

import { QRCGTitleController } from '../core/qrcg-title-controller'

import '../dashboard/qrcg-dashboard-layout'

import './qrcg-system-status'

export class QrcgSystemStatusPage extends LitElement {
    titleController = new QRCGTitleController(this)

    static styles = [
        css`
            :host {
                display: block;
            }

            .refresh {
                margin: 0.1rem;
                /* font-size: 2rem; */
            }

            .refresh::part(button) {
                padding: 0;
                width: 2.5rem;
                height: 2.5rem;
                min-width: 0;
            }

            .refresh qrcg-icon {
                width: 1.5rem;
                height: 1.5rem;
            }
        `,
    ]

    onRefreshClick() {
        document.dispatchEvent(
            new CustomEvent('qrcg-system-status:request-refresh')
        )
    }

    render() {
        return html`
            <qrcg-dashboard-layout>
                <span slot="title"> ${this.titleController.pageTitle} </span>

                <qrcg-button
                    @click=${this.onRefreshClick}
                    transparent
                    slot="header-actions"
                    class="refresh"
                    title="refresh"
                >
                    <qrcg-icon mdi-icon=${mdiRefresh}></qrcg-icon>
                </qrcg-button>
                <qrcg-system-status slot="content"></qrcg-system-status>
            </qrcg-dashboard-layout>
        `
    }
}
customElements.define('qrcg-system-status-page', QrcgSystemStatusPage)
