import { html, css } from 'lit'
import { isEmpty } from '../core/helpers'

import './qrcg-loader-h'

export const LoadableTable = (superClass) =>
    class extends superClass {
        static get styles() {
            return [
                css`
                    :host {
                        transition: opacity 0.5s ease-in-out;
                    }

                    :host([loading]) {
                        opacity: 0.4;
                        pointer-events: none;
                        user-select: none;
                        -webkit-user-select: none;
                    }

                    qrcg-loader-h {
                        --qrcg-loader-h-color: black;
                        transform: scale(0.5) translateY(-1.6rem);
                        height: 22.7109px;
                    }

                    @media screen and (max-width: 600px) {
                        qrcg-loader-h {
                            height: 14.7109px;
                            margin-left: auto;
                        }
                    }
                `,
            ]
        }

        static get properties() {
            return {
                firstLoad: { type: Boolean },
            }
        }

        connectedCallback() {
            super.connectedCallback()
            this.firstLoad = true
        }

        updated(changed) {
            if (changed.has('rows') || changed.has('columns'))
                if (
                    isEmpty(this.rows) &&
                    !isEmpty(this.columns) &&
                    this.firstLoad
                ) {
                    this.initPlaceholderRows()
                }

            if (changed.has('loading') && this.loading) {
                this.initPlaceholderRows()
                this.firstLoad = false
            }
        }

        initPlaceholderRows() {
            const length = this.rows.length > 0 ? this.rows.length : 10

            this.rows = Array.from({ length }).map(() => {
                return this.columns.reduce((row, col) => {
                    row[col.key] = html`<qrcg-loader-h></qrcg-loader-h>`

                    return row
                }, {})
            })
        }
    }
