import { LitElement, html, css } from 'lit'

class QRCGBox extends LitElement {
    static get styles() {
        return css`
            :host {
                display: block;
                box-shadow: 2px 2px 3px 2px rgba(0, 0, 0, 0.1);
                padding: 1rem 2rem;
                background-color: white;
                border-radius: 0.5rem;
            }

            .container {
                border-radius: 0.5rem;
                overflow: hidden;
            }
        `
    }
    render() {
        return html`
            <div class="container" part="container">
                <slot></slot>
            </div>
        `
    }
}

window.customElements.define('qrcg-box', QRCGBox)
