import { LitElement, html, css } from 'lit'

import { mdiCheckboxBlankOutline, mdiCheckboxMarked } from '@mdi/js'

import './qrcg-icon'

class QRCGCheckBox extends LitElement {
    static get styles() {
        return css`
            :host {
                display: inline-flex;
                cursor: pointer;
                user-select: none;
                -webkit-user-select: none;
                touch-action: manipulation;
                align-items: center;
                font-size: 0.8rem;
                font-weight: bold;
            }

            qrcg-icon {
                margin-right: 0.5rem;
            }

            label {
                cursor: pointer;
            }
        `
    }

    static get properties() {
        return {
            value: {
                type: Boolean,
            },
            name: {},
        }
    }

    constructor() {
        super()

        this.value = false
    }

    connectedCallback() {
        super.connectedCallback()

        this.addEventListener('click', this.onClick)
    }

    disconnectedCallback() {
        super.disconnectedCallback()
        this.removeEventListener('click', this.onClick)
    }

    onClick = () => {
        this.value = !this.value

        this.dispatchEvent(
            new CustomEvent('on-input', {
                bubbles: true,
                composed: true,
                detail: {
                    value: this.value,
                    name: this.name,
                },
            })
        )
    }

    render() {
        const icon = this.value ? mdiCheckboxMarked : mdiCheckboxBlankOutline

        return html`
            <qrcg-icon mdi-icon=${icon}></qrcg-icon>

            <label><slot></slot></label>
        `
    }
}

window.customElements.define('qrcg-checkbox', QRCGCheckBox)
