import { html } from 'lit'

import './qrcg-modal'

import { QrcgModal } from './qrcg-modal'

class QRCGConfirmationModal extends QrcgModal {
    static get properties() {
        return {
            ...super.properties,
            title: {},
            message: {},
            affirmativeText: {},
            negativeText: {},
        }
    }

    renderTitle() {
        return this.title
    }

    renderBody() {
        return this.message
    }

    renderActions() {
        return html`
            ${(this.negativeText &&
                html`<qrcg-button transparent modal-negative
                    >${this.negativeText}</qrcg-button
                >`) ||
            ''}
            <qrcg-button modal-affirmative>${this.affirmativeText}</qrcg-button>
        `
    }
}

export async function confirm({
    title = 'Confirmation',
    message = 'Are you sure you want to perform this action',
    affirmativeText = 'Confirm',
    negativeText = 'Cancel',
} = {}) {
    const modal = new QRCGConfirmationModal()

    modal.title = title

    modal.message = message

    modal.affirmativeText = affirmativeText

    modal.negativeText = negativeText

    document.body.appendChild(modal)

    await new Promise((resolve) => setTimeout(resolve, 0))

    return modal.open()
}

window.customElements.define('qrcg-confirmation-modal', QRCGConfirmationModal)
