import { LitElement, html, css } from 'lit'

export class QRCGSimpleTitleContentSection extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                background-color: white;
                padding: 1rem;
                text-align: center;
                line-height: 1.8;
                margin: 2rem 0;
            }

            [name='content']::slotted(*) {
                color: black;
            }

            .content-container {
                max-width: var(--container-max-width);
                margin: auto;
            }
        `,
    ]

    render() {
        return html`
            <slot name="title"></slot>
            <div class="content-container">
                <slot name="content"></slot>
            </div>
        `
    }
}
customElements.define(
    'qrcg-simple-title-content-section',
    QRCGSimpleTitleContentSection
)
