import { html } from 'lit'
import { t } from '../core/translate'

import { QrcgDashboardForm } from '../dashboard/qrcg-dashboard-form'

import '../common/qrcg-relation-select'

export class QrcgUserForm extends QrcgDashboardForm {
    constructor() {
        super({
            apiBaseRoute: 'users',
            bindEvents: true,
        })
    }

    connectedCallback() {
        super.connectedCallback()
        this.addEventListener('api:success', this.onSuccess)
    }

    disconnectedCallback() {
        super.disconnectedCallback()
        this.removeEventListener('api:success', this.onSuccess)
    }

    onSuccess(e) {
        const data = e.detail.response

        setTimeout(() => {
            this.data = {
                ...this.data,
                role_id: data.roles[0]?.id,
            }
        }, 0)
    }

    renderFormFields() {
        return html`
            <qrcg-input name="name" placeholder="${t`Full name`}"
                >${t`Name`}</qrcg-input
            >

            <qrcg-input
                name="email"
                placeholder=${t`email@example.com`}
                type="email"
                >${t`Email`}</qrcg-input
            >

            <qrcg-input
                name="password"
                type="password"
                placeholder=${t`at least 6 charachters`}
                >${t`Password`}</qrcg-input
            >

            <qrcg-input
                name="password_confirmation"
                type="password"
                placeholder=${t`at least 6 charachters`}
                >${t`Confirm password`}</qrcg-input
            >

            <qrcg-relation-select endpoint="roles" name="role_id"
                >${t`Role`}</qrcg-relation-select
            >
        `
    }
}
customElements.define('qrcg-user-form', QrcgUserForm)
