import { html } from 'lit'
import { isEmpty, queryParam } from '../core/helpers'
import { t } from '../core/translate'
import { QRCGDashboardList } from '../dashboard/qrcg-dashboard-list'

export class QrcgUserList extends QRCGDashboardList {
    constructor() {
        super({
            baseRoute: 'users',
            singularRecordName: 'user',
            frontendFormUrl: null,
        })

        this.cellContentRenderer = this.cellContentRenderer.bind(this)
    }

    static listColumns = [
        { key: 'id', label: 'ID', width: '2rem' },
        { key: 'name', label: 'Name' },
        { key: 'email', label: 'Email' },
        { key: 'created_at', label: 'Created at' },
        { key: 'actions', label: 'Actions', width: '7rem' },
    ]

    static get properties() {
        return {
            ...super.properties,
            paying: {},
        }
    }

    cellContentRenderer(row, column) {
        switch (column.key) {
            case 'active_subscriptions.status': {
                // Loader is visible
                if (!isEmpty(row[column.key])) return row[column.key]

                if (isEmpty(row.subscriptions))
                    return this.constructor.STATUS_INACTIVE

                // Push active subscription to the top
                const sorted = row.subscriptions.sort((a, b) => {
                    if (a.status === this.constructor.STATUS_ACTIVE) {
                        return -1
                    }

                    if (b.status === this.constructor.STATUS_ACTIVE) {
                        return 1
                    }

                    return 0
                })

                return sorted[0].status
            }
            default:
                return super.cellContentRenderer(row, column)
        }
    }

    searchPlaceholder() {
        return t('By name or email')
    }

    locationChanged() {
        super.locationChanged()
        this.paying = queryParam('paying')
    }

    extendFetchDependencies(dependencies) {
        dependencies.push('paying')
    }

    deleteMessage() {
        let message = super.deleteMessage()

        return html`<div>
            ${message}
            <br />
            ${t`This will delete all related`}
            <strong>${t`QR Codes`}</strong>,
            <strong>${t`subscriptions`}</strong> ${t`and`}
            <strong>${t`transactions`}</strong>.
        </div>`
    }

    extendSearch(search) {
        if (this.paying) {
            search.paying = this.paying
        }
    }
}
customElements.define('qrcg-user-list', QrcgUserList)
