<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use App\Jobs\WebhooksRegistrar;
use App\Jobs\MakeSubscriptionsExpired;
use App\Models\Config as ModelsConfig;
use App\Support\FileOwnership;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;

class Kernel extends ConsoleKernel
{
    const CRON_LAST_RUN_CONFIG_KEY = 'cron.last_run';
    /**
     * Define the application's command schedule.
     *
     * @param  \Illuminate\Console\Scheduling\Schedule  $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {

        $schedule->job(app(WebhooksRegistrar::class))->everyMinute();

        $schedule->job(app(MakeSubscriptionsExpired::class))->twiceDaily();

        $schedule->call(function () {
            // Fix storage file permission issue in docarized platform
            FileOwnership::setStorageOwnership();
        })->everyTenMinutes();

        $schedule->call(function () {
            ModelsConfig::set(static::CRON_LAST_RUN_CONFIG_KEY, time());
        })->everyMinute();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
