<?php

namespace App\Http\Controllers;

use App\Events\FileDeleted;
use App\Events\QRCodeLogoDeleted;
use App\Interfaces\FileManager;
use App\Models\File;
use App\Models\QRCode;
use Illuminate\Http\Request;

class FilesController extends Controller
{
    public function store(Request $request, FileManager $files)
    {
        return $files->store($request);
    }

    public function resource(Request $request, File $file, FileManager $files)
    {
        return $files->resource($request, $file);
    }

    public function show(File $file)
    {
        return $file;
    }

    public function destroy(File $file, FileManager $files)
    {
        $files->delete($file);

        event(new FileDeleted($file));

        return $file;
    }
}
