<?php

namespace App\Http\Controllers;

use App\Http\Requests\StorePaymentGatewayRequest;
use App\Http\Requests\UpdatePaymentGatewayRequest;
use App\Http\Resources\PaymentGatewayCollection;
use App\Http\Resources\PaymentGatewayResource;
use App\Interfaces\ModelIndex;
use App\Models\OfflinePaymentGatewayModel;
use App\Models\PaymentGateway;
use App\Models\PaypalPaymentGateway;
use App\Models\StripePaymentGatewayModel;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PaymentGatewayController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, ModelIndex $modelIndex)
    {
        $data = $modelIndex
            ->build(new PaymentGateway(), $request)
            ->list()
            ->through(function ($paymentGateway) {
                return new PaymentGatewayResource($paymentGateway);
            });

        return $data;
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\PaymentGateway  $paymentGateway
     * @return \Illuminate\Http\Response
     */
    public function show(PaymentGateway $paymentGateway)
    {
        return new PaymentGatewayResource($paymentGateway);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \App\Http\Requests\UpdatePaymentGatewayRequest  $request
     * @param  \App\Models\PaymentGateway  $paymentGateway
     * @return \Illuminate\Http\Response
     */
    public function update(UpdatePaymentGatewayRequest $request, PaymentGateway $paymentGateway)
    {
        $data = $request->all();

        if (app()->environment('demo')) {
            $data = $request->except([
                ...StripePaymentGatewayModel::instance()->payment_fields,
                ...PaypalPaymentGateway::instance()->payment_fields,
                ...OfflinePaymentGatewayModel::instance()->payment_fields,
            ]);
        }

        $paymentGateway = $paymentGateway->make()->fill($data);

        $paymentGateway->save();

        return new PaymentGatewayResource($paymentGateway);
    }
}
