<?php

namespace App\Http\Controllers;

use App\Models\QRCodeRedirect;

use Illuminate\Http\Request;

use App\Models\QRCodeScan;

use App\Interfaces\DeviceInfo;
use App\Interfaces\SubscriptionManager;

class QRCodeRedirectController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request, DeviceInfo $info, $slug, SubscriptionManager $subscriptionManager)
    {
        if ($info->isBot()) {
            abort(403);
        }

        $redirect = QRCodeRedirect::whereSlug($slug)->first();

        if (!$redirect) {
            abort(404);
        }

        $user = $redirect->qrcode->user;

        if (!$subscriptionManager->userHasActiveSubscription($user)) {
            abort(403, t('Subscription is expired.'));
        }

        if ($subscriptionManager->userScanLimitReached($user)) {
            abort(403, t('Scan limit reached.'));
        }

        if ($redirect->qrcode->archived) {
            abort(403, t('QR code is archived.'));
        }

        $scan = new QRCodeScan;

        $scan->qrcode_redirect_id = $redirect->id;

        $scan->qrcode_id = $redirect->qrcode_id;

        $scan->ip_address = $request->ip();

        $scan->device_name = $info->getDeviceName();

        $scan->device_brand = $info->getDeviceBrand();

        $scan->device_model = $info->getDeviceModel();

        $scan->os_name = $info->getOSName();

        $scan->os_version = $info->getOSVersion();

        $scan->client_type = $info->getClientType();

        $scan->client_name = $info->getClientName();

        $scan->client_version = $info->getClientVersion();

        $scan->save();

        return redirect($redirect->destination);
    }
}
