<?php

namespace App\Http\Requests;

use App\Models\PaypalPaymentGateway;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UpdatePaymentGatewayRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'enabled' => 'required|boolean',
            'mode' => ['required', Rule::in(PaypalPaymentGateway::getModes())]
        ];
    }
}
