<?php

namespace App\Interfaces;

use App\Models\File;
use Closure;
use Illuminate\Http\Request;

interface FileManager
{
    public const FILE_TYPE_QRCODE_LOGO = 'qrcode/logo';

    public const FILE_TYPE_QRCODE_FOREGROUND_IMAGE = 'qrcode/foreground_image';

    public const FILE_TYPE_TRANSLATION = 'translation/file';

    public const FILE_TYPE_TRANSACTION_PROOF_OF_PAYMENT = 'transaction/proof-of-payment';

    public const FILE_TYPE_CONFIG_ATTACHMENT = 'config/attachment';

    public const UPLOAD_DIR = 'files';

    public function store(Request $request);

    public function validate(Request $request);

    public function resource(Request $request, File $file);

    public function delete(File $file);

    public function path(File $file);

    public function url(File $file);

    public function copy(File $file, $to);

    public function extension(File $file);

    /**
     * @param Closure function($file)
     */
    public function setFileValidator(Closure $callback);

    public function save(
        $name,
        $type,
        $mime_type,
        $attachable_type,
        $attachable_id,
        $user_id,
        $extension = null,
        $data = null,
    );

    public function duplicate(File $file): File;
}
