<?php

namespace App\Interfaces;

use App\Models\Subscription;
use App\Models\User;

interface SubscriptionManager
{
    public function setExpiredSubscriptions();

    public function saveSubscription($data);

    public function activateSubscription(Subscription $subscription);

    public function deactivateSubscription(Subscription $subscrption);

    public function userHasActiveSubscription(User $user);

    public function userScanLimitReached(User $user);
}
