<?php

namespace App\Listeners;

use App\Events\SubscriptionPlanDeleted;
use App\Repositories\PaypalPaymentGateway;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

use App\Models\PaypalPaymentGateway as Settings;

class DeactivatePaypalPlan
{
    private PaypalPaymentGateway $paypal;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        $this->paypal = new PaypalPaymentGateway;
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\SubscriptionPlanDeleted  $event
     * @return void
     */
    public function handle(SubscriptionPlanDeleted $event)
    {
        if (!Settings::isEnabled()) {
            return;
        }

        $subscriptionPlan = $event->model;

        $this->paypal->deactivatePlan($subscriptionPlan);
    }
}
