<?php

namespace App\Listeners;

use App\Events\QRCodeSaved;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Models\QRCode;
use App\Models\QRCodeRedirect;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;


class GenerateQRCodeRedirect
{

    private $qrcode;

    private $slugLength = 6;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\QRCodeSaved  $event
     * @return void
     */
    public function handle(QRCodeSaved $event)
    {
        $this->qrcode = $event->qrcode;

        if ($this->qrcode->type !== 'url') return;

        $redirect = QRCodeRedirect::where('qrcode_id', $this->qrcode->id)->first();

        if (!$redirect) {
            $redirect = $this->makeRedirect();
        } else {
            $redirect->destination = $this->qrcode->data->url;
            $redirect->save();
        }
    }

    private function randomSlug()
    {
        return strtolower(Str::random($this->slugLength));
    }

    private function makeRedirect()
    {
        $redirect = new QRCodeRedirect();

        $redirect->slug = $this->randomSlug();

        while (QRCodeRedirect::whereSlug($redirect->slug)->first()) {
            $redirect->slug = $this->randomSlug();
        }

        $redirect->qrcode_id = $this->qrcode->id;

        $redirect->destination = $this->qrcode->data->url;

        $redirect->save();

        return $redirect;
    }
}
