<?php

namespace App\Models;

use App\Events\SavingSubscription;
use App\Events\SubscriptionCreated;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;

class Subscription extends Model
{
    use HasFactory;

    protected $fillable = ['subscription_plan_id', 'user_id', 'paypal_id', 'paypal_order_id'];

    public function statuses()
    {
        return $this->hasMany(SubscriptionStatus::class)->orderBy('id', 'desc');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function subscription_plan()
    {
        return $this->belongsTo(SubscriptionPlan::class);
    }

    public function transactions()
    {
        return $this->hasMany(Transaction::class);
    }
}
