<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    const STATUS_SUCESS = 'success';
    const STATUS_FAILED = 'failed';

    const STATUS_PENDING_CONFIRMATION = 'pending_confirmation';

    public $casts = [
        'approved_at' => 'date',
        'rejected_at' => 'date'
    ];

    public function subscription()
    {
        return $this->belongsTo(Subscription::class);
    }

    public function payment_gateway()
    {
        return $this->belongsTo(PaymentGateway::class);
    }

    public function payment_proof()
    {
        return $this->morphOne(File::class, 'attachable');
    }
}
