<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Translation extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'locale'];

    protected $appends = ['translation_file_id'];

    protected $casts = [
        'is_default' => 'boolean'
    ];

    protected $with = ['file'];

    public function translationFileId(): Attribute
    {
        return new Attribute(fn () => $this->file?->id);
    }

    public function file()
    {
        return $this->morphOne(File::class, 'attachable');
    }
}
