<?php

namespace App\Notifications;

use App\Interfaces\FileManager;
use App\Models\Transaction;
use Illuminate\Notifications\Messages\MailMessage;

use Illuminate\Notifications\Notification;
use Illuminate\Support\HtmlString;

class TransactionNotification extends Notification
{
    protected Transaction $transaction;

    protected FileManager $files;

    protected function renderTransactionDetails(MailMessage $message)
    {
        $this->files = app(FileManager::class);

        $lines = [
            sprintf('Transaction ID: %s.', $this->transaction->id),
            sprintf('Sent by: %s.', $this->transaction->subscription->user->name),
            sprintf('Amount: $%s.', $this->transaction->amount),
            sprintf('Date: %s.', $this->transaction->created_at),
            sprintf(
                'Payment Proof: <a href="%s" target="_blank">click here to view</a>.',
                $this->files->url($this->transaction->payment_proof)
            )
        ];

        foreach ($lines as $line) {
            $message->line(new HtmlString($line));
        }

        return $message;
    }
}
