<?php

namespace App\Policies;

use App\Models\QRCode;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Support\Facades\Log;

class QRCodePolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     *
     * @param  \App\Models\User  $user
     * @return \Illuminate\Auth\Access\Response|bool
     */
    public function list(User $user)
    {
        return $user->permitted('qrcode.list');
    }

    public function listAll(User $user)
    {
        return $user->permitted('qrcode.list-all');
    }

    public function show(User $user, QRCode $qrcode)
    {
        if ($user->permitted('qrcode.show-any')) {
            return true;
        }

        return $user->permitted('qrcode.show') && $qrcode->user_id == $user->id;
    }

    public function store(User $user)
    {
        return $user->permitted('qrcode.store');
    }

    public function update(User $user, QRCode $qrcode)
    {
        if ($user->permitted('qrcode.update-any')) {
            return true;
        }

        return $user->permitted('qrcode.update') && $qrcode->user_id == $user->id;
    }

    public function archive(User $user, QRCode $qrcode)
    {
        if ($user->permitted('qrcode.archive-any')) {
            return true;
        }

        return $user->permitted('qrcode.archive') && $qrcode->user_id == $user->id;
    }

    public function showStats(User $user, QRCode $qrcode)
    {
        if ($user->permitted('qrcode.showStats-any')) {
            return true;
        }

        return $user->permitted('qrcode.showStats') && $qrcode->user_id == $user->id;
    }
}
