<?php

namespace App\Providers;



use App\Support\ContentBlockComposer;
use App\Support\ContentManager;
use App\Support\FaviconManager;
use App\Support\Mail\PHPMailerTransport;
use App\Support\PageTitle;

use Illuminate\Support\ServiceProvider;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Log;

use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;


class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        try {
            DB::listen(function ($query) {
                if (false) {
                    Log::debug($query->sql);
                    Log::debug($query->bindings);
                    Log::debug($query->time);
                }
            });
        } catch (\Throwable $ex) {
        }

        if (config('app.force_https')) {
            URL::forceScheme('https');

            $this->app['request']->server->set('HTTPS', true);

            Config::set('app.url', url('/'));
        }

        $this->bootMacros();

        $this->app->singleton('pageTitle', function ($app) {
            return new PageTitle();
        });

        $this->app->singleton('contentManager', function () {
            return app(ContentManager::class);
        });

        Paginator::defaultView('pagination/default');

        Paginator::defaultSimpleView('pagination/simple-default');

        ContentBlockComposer::boot();

        JsonResource::withoutWrapping();

        Mail::extend('smtp', function () {
            return new PHPMailerTransport();
        });

        FaviconManager::boot();
    }

    private function bootMacros()
    {
        foreach (glob(base_path('macros/*.php')) as $file) {
            require_once $file;
        }
    }
}
