<?php

namespace App\Support;

use App\Models\ContentBlock;
use Illuminate\View\View;

use Illuminate\Support\Facades\View as ViewFacade;

class ContentBlockComposer
{
    public function __construct()
    {
    }

    public static function boot()
    {
        ViewFacade::composer('content-block.main', static::class);
    }

    /**
     * Bind data to the view.
     *
     * @param  \Illuminate\View\View  $view
     * @return void
     */
    public function compose(View $view)
    {
        $position = $view->gatherData()['position'];

        try {
            $blocks = ContentBlock::where('position', $position)
                ->orderBy('sort_order', 'asc')
                ->get();
            $view->with('contentBlocks', $blocks);
        } catch (\Throwable $th) {
        }
    }
}
