<?php

namespace App\Support;

use App\Http\Controllers\PageController;
use App\Models\Config;
use App\Models\Page;
use Exception;
use Illuminate\Support\Facades\Route;

class PageManager
{
    public static function registerRoutes()
    {
        try {
            $pages = static::instance()->getPublishedPages();

            foreach ($pages as $page) {
                Route::get($page->slug, [PageController::class, 'viewPage']);
            }
        } catch (Exception $ex) {
        }
    }

    public static function instance()
    {
        return new static;
    }

    public function getPublishedPages()
    {
        return Page::where('published', true)->get();
    }

    public static function renderQrTypeConfigsJsVariable()
    {
        try {
            $types =
                Config::where('key', 'like', 'qrType%')
                ->get()
                ->reduce(function (
                    $result,
                    $configItem
                ) {
                    $result[$configItem->key] = Config::get($configItem->key);
                    return $result;
                }, []);

            return sprintf('<script> var QRCG_QR_TYPE_CONFIGS = %s; </script>', json_encode($types));
        } catch (Exception $ex) {
        }

        return '';
    }
}
