<?php

namespace App\Support;

use App\Events\ShouldSaveQRCodeVariants;
use App\Interfaces\FileManager;
use App\Models\QRCode;
use Illuminate\Support\Facades\Log;

class QRCodeManager
{
    public function copy(QRCode $qrcode): QRCode
    {
        $data = $qrcode->toArray();

        $clone = new QRCode($data);

        $clone->user_id = $qrcode->user_id;

        $clone->name = $this->makeCopyName($qrcode);

        $clone->generateFileName();

        copy($qrcode->getFilePath('svg'), $clone->getFilePath('svg'));

        $clone->save();

        $this->copyFile($qrcode, $clone, 'foreground_image');

        $this->copyFile($qrcode, $clone, 'logo');

        $clone->refresh();

        event(new ShouldSaveQRCodeVariants($clone));

        return $clone;
    }

    private function copyFile(QRCode $original, QRCode $clone, string $relationName)
    {
        if (!$original[$relationName]) {
            return null;
        }

        /** @var \App\Interfaces\FileManager */
        $files = app(FileManager::class);

        $file = $files->duplicate($original[$relationName]);

        $file->attachable_id = $clone->id;

        $file->save();



        return $file;
    }

    private function makeCopyName(QRCode $qrcode)
    {
        $prefix = t('Copy of');

        $number = preg_replace('/[^\d]/', '', $qrcode->name);

        $name = str_replace($number, '', $qrcode->name);

        $name = str_replace($prefix, '', $name);

        $name = trim($name);

        $number = empty($number) ? 1 : $number;

        $makeName = fn ($n) => "$prefix $name $n";

        while (QRCode::whereName($makeName($number))->first()) {
            $number++;
        }

        return $makeName($number);
    }
}
