<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

use SVG\Nodes\Shapes\SVGPath;
use SVG\Nodes\Structures\SVGSymbol;

class AppleShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'apple';

    protected function symbolPath()
    {
        return 'm 447.74868,161.30591 c 7.73458,-21.92213 25.8058,-49.29619 44.21413,-66.97499 40.67688,-39.064847 91.63168,-56.360368 152.58209,-51.790732 l 18.57797,1.392846 -1.13001,5.019194 c -0.62151,2.760557 -5.13077,13.114907 -10.02059,23.009668 -7.57612,15.330609 -11.56221,20.650339 -26.96054,35.980944 -34.91928,34.7657 -81.61115,53.1818 -148.63499,58.6243 -34.44356,2.7969 -31.65213,3.30991 -28.62806,-5.26123 z m -78.3762,728.58576 C 249.56925,878.35493 169.1632,805.61939 136.24899,679.00754 125.68868,638.38492 122.36951,615.16657 122.7046,584.26132 c 0.52852,-48.7454 7.4711,-90.09669 23.05841,-137.34007 17.84809,-54.09558 28.75127,-74.23654 53.9385,-99.63821 12.67772,-12.78566 18.25938,-16.82477 33.22778,-24.04491 25.91407,-12.49988 43.33959,-16.74669 73.25952,-17.85421 30.14518,-1.11585 40.49145,0.51537 80.83268,12.74435 37.8477,11.47309 45.38135,13.20922 65.58096,15.11319 26.9385,2.53915 49.86056,-0.53804 91.04081,-12.22185 44.69713,-12.68163 63.76915,-15.40569 86.64582,-12.37565 28.04029,3.71398 51.15345,12.89505 77.93746,30.95852 45.35445,30.58762 82.42042,92.89225 98.79891,166.07228 4.07978,18.22875 4.43457,24.05723 4.3775,71.91414 -0.054,45.28503 -0.6096,55.13347 -4.2596,75.50566 C 788.52974,756.98468 722.30933,839.1402 628.8032,874.35 c -17.50924,6.59312 -47.23182,13.31716 -69.26482,15.66957 l -18.9974,2.02829 -20.17631,-6.68053 c -39.45413,-13.06356 -73.17237,-12.47387 -113.79814,1.9902 -7.09256,2.52517 -14.76219,4.47511 -17.04361,4.33319 -2.28142,-0.14203 -11.34913,-0.95151 -20.15044,-1.79905 z M 752.37101,589.42474 c 5.85155,-24.34494 7.50887,-40.80745 6.4343,-63.91353 -2.18175,-46.91348 -18.39412,-85.86474 -51.1914,-122.99057 -11.47108,-12.98504 -35.96316,-33.4907 -48.24861,-40.39552 l -7.46027,-4.19291 -7.03473,13.38712 c -3.86911,7.36291 -6.7423,13.58149 -6.3849,13.81907 0.35743,0.23758 6.51507,4.18345 13.68365,8.76862 39.08351,24.99855 67.48949,68.9855 75.12803,116.33655 3.07281,19.04829 1.32501,52.97564 -3.6143,70.15868 -2.09148,7.2759 -3.51301,13.51857 -3.15898,13.87261 1.10318,1.10319 22.60581,7.57785 25.77079,7.75984 2.18487,0.12555 3.84172,-3.31269 6.07642,-12.60996 z';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 489.40682,269.51913 -9.70345,18.97457 h 0.005 c 27.17448,14.5661 48.24667,38.36627 59.41312,67.10664 11.16112,28.74038 11.68167,60.52725 1.46288,89.61679 l 20.36455,6.28861 C 599.00901,327.61932 490.5829,270.04927 489.40616,269.5162 Z m 72.28406,-18.44416 C 519.57582,213.1205 471.28249,200.32953 422.24021,213.97341 l -37.63197,10.66137 c -7.67325,2.0875 -15.52828,3.44615 -23.45767,4.05012 -1.49405,-28.27262 -9.48488,-55.81625 -23.34839,-80.49598 173.78028,-3.40978 183.05567,-122.3925 183.05567,-123.667866 v -9.490083 l -9.38081,-1.598138 C 393.13454,-7.8899015 334.49835,60.87858 314.02853,113.43512 295.2312,90.21733 273.22615,69.790151 248.67569,52.771944 l -11.411,17.376696 c 89.98193,63.9682 101.60016,132.52212 102.56368,158.00146 -7.91274,-0.82251 -15.73218,-2.38948 -23.3484,-4.69034 l -31.9841,-9.80765 c -46.02379,-14.8886 -96.31212,-8.14702 -136.78534,18.34021 -18.97456,12.68636 -34.33226,33.2648 -48.080088,64.92639 -20.479159,47.44576 -30.791367,98.65363 -30.282288,150.32528 l 0.530997,7.14232 C 86.084424,602.15285 165.08648,685.95119 292.06203,690.53558 h 0.005 c 7.07463,0.1718 14.097,-1.20773 20.57778,-4.05012 23.80549,-10.3074 50.81873,-10.3074 74.62956,0 6.02301,2.62376 12.51459,4.00321 19.07853,4.05012 h 1.59814 C 534.92957,685.94933 630.66732,581.89626 630.66732,448.52255 v -36.46054 c 0.32275,-54.47825 -30.7034,-126.6557 -68.97639,-160.98664 z M 469.36212,30.704514 c 9.66706,0.02603 19.31839,0.70277 28.8923,2.03019 -6.07512,25.695228 -34.5455,93.390906 -165.35781,94.031926 9.22462,-28.663088 27.53298,-53.541386 52.15142,-70.871439 24.62375,-17.330052 54.21837,-26.174989 84.31275,-25.190144 z M 609.6657,448.52348 c 0,121.64753 -86.8888,216.53237 -202.56597,220.69031 v -0.005 c -3.92511,0.0365 -7.81385,-0.76524 -11.411,-2.34257 -29.28278,-12.50418 -62.40097,-12.50418 -91.68375,0 -3.58675,1.60853 -7.48069,2.41027 -11.411,2.34257 C 175.31895,665.04905 106.02006,589.99317 90.880921,452.46286 v -6.07512 c -0.426874,-48.44924 9.271389,-96.45738 28.464519,-140.94326 7.98043,-22.00507 21.98373,-41.32347 40.40658,-55.75895 35.12254,-22.75936 78.61692,-28.51249 118.45178,-15.66955 l 31.9841,9.80766 c 26.06971,8.02721 53.89455,8.39689 80.16816,1.06718 l 37.63195,-10.66137 c 52.66716,-14.6074 94.03193,9.59416 119.51392,31.9841 33.69126,30.38623 62.15711,96.80654 62.15711,145.20782 z',
            $this->frameId()
        );
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(-9%%, 10%%) scale(2.8);
        }

        #%2$s path {
            transform: scale(0.75);
        }

        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId(), $this->qrcode->design->frameColor);
    }

    protected function frameStrokeWidth()
    {
        return 2;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
