<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class BakeryShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'bakery';

    protected function symbolPath()
    {
        return 'm 486.17275,785.36585 c 0.12811,-6.70568 41.88316,-247.10938 43.09334,-248.10887 1.39478,-1.15193 225.33755,-12.52741 226.36639,-11.49858 0.81129,0.8113 -33.62328,200.88346 -34.67906,201.49273 -1.27883,0.73798 -231.78181,62.80148 -233.24384,62.80148 -0.8945,0 -1.58608,-2.10904 -1.53683,-4.68676 z m 205.61471,-283.86938 -25.95525,-0.87364 9.13442,-17.9824 c 22.19773,-43.69933 17.4661,-109.79152 -13.03378,-182.05788 -18.21374,-43.15563 -53.86219,-95.03122 -79.29489,-115.3899 -6.16503,-4.93505 -10.78702,-9.39493 -10.27111,-9.91085 2.22507,-2.22507 157.97685,38.9982 176.39346,46.68657 29.85,12.46145 58.01345,32.14805 81.10192,56.69123 51.07029,54.28805 69.71157,137.72866 41.71936,186.74116 -9.7361,17.04725 -25.08206,24.96912 -63.20267,32.62633 -27.12295,5.44815 -43.40805,5.93274 -116.59146,3.46938 z m -411.92137,256.79621 -172.74031,-33.94112 0.80855,-9.33025 c 1.86659,-21.53946 27.45455,-261.87946 28.81286,-270.63051 1.44305,-9.29705 0.92695,-9.98062 -19.13773,-25.34893 C 69.11404,381.89737 44.537424,336.22954 51.419942,296.04969 66.400432,208.59419 195.73149,137.1178 341.46341,135.7536 c 49.52471,-0.4636 78.52494,3.99073 121.34223,18.6377 58.27045,19.9332 84.87664,35.97662 119.89254,72.29473 45.8204,47.52444 75.59676,110.2652 81.60489,171.94699 4.44323,45.61581 -15.84474,88.25524 -48.69121,102.33489 -14.65663,6.28255 -47.72122,10.55768 -81.65513,10.55768 h -25.916 l -2.72429,15.39933 c -1.49837,8.46963 -12.15835,71.74079 -23.68883,140.60258 -16.93824,101.15769 -21.73818,125.15553 -24.99287,124.95477 -2.21558,-0.13666 -81.76147,-15.52196 -176.76865,-34.18959 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 262.13086,84.154297 c -8.31167,0.134787 -16.55796,0.552544 -24.85549,1.261245 -4.12386,0.359154 -8.39998,0.791651 -12.52088,1.299355 -24.58146,2.976657 -48.9267,8.480639 -72.41955,16.434423 -18.37961,6.24651 -36.31831,14.09918 -53.227518,23.71591 -8.464051,4.83322 -16.905485,10.27648 -24.817954,16.19781 -6.306062,4.71026 -12.38087,9.78462 -18.023467,15.20554 -11.506442,11.05123 -21.636904,23.76802 -28.496822,38.23867 -6.0528,12.72524 -9.327957,26.88651 -8.623946,41.0065 0.149485,3.34205 0.528041,6.6716 1.079376,9.97063 0.09639,0.52546 0.261566,1.47479 0.373843,2.02411 2.2034,11.33716 6.7384,22.13528 12.680845,32.00713 6.225446,10.33731 14.031574,19.86029 22.549728,28.47661 8.262411,8.383 17.3158,15.95091 26.697715,23.03999 1.185836,0.77564 1.772224,2.23133 1.521844,3.61581 -0.916093,8.14661 -1.70324,16.30953 -2.569257,24.46247 -6.733995,64.887 -13.467989,129.77399 -20.201983,194.66098 99.212886,19.84375 198.425786,39.6875 297.638676,59.53125 0.48831,-0.97459 0.97594,-1.94953 1.46484,-2.92382 63.28332,-17.57901 126.56639,-35.15893 189.84961,-52.73829 2.26237,-2.82747 4.52474,-5.65494 6.78711,-8.48242 9.24907,-53.35084 18.49515,-106.70221 27.74609,-160.05273 11.25091,-0.96416 22.51421,-1.80202 33.7531,-2.89416 6.06378,-0.72829 12.158,-2.11876 17.83675,-4.17029 1.49622,-0.53715 3.22032,-1.22754 4.68746,-1.88121 3.40483,-1.50858 6.88468,-3.40378 10.03352,-5.55726 9.06127,-6.11039 16.31486,-14.74319 21.09825,-24.54623 6.64708,-13.4614 9.01024,-28.67628 8.74723,-43.65662 -0.3805,-18.27421 -4.57359,-36.33707 -11.18495,-53.33004 -2.19748,-5.63673 -4.7447,-11.29673 -7.51714,-16.73892 -13.70577,-26.97015 -33.84706,-50.91389 -58.37991,-68.78248 -9.78272,-7.14146 -20.40248,-13.39306 -31.47874,-18.46945 -1.54085,-0.70155 -2.92547,-1.34428 -4.48762,-1.92291 -68.58637,-16.80271 -137.17587,-33.59429 -205.76029,-50.403947 -12.66081,-4.215248 -25.63925,-7.45781 -38.77344,-9.804687 -5.87353,-1.04198 -11.93368,-1.939528 -17.86974,-2.63632 -8.0419,-0.944515 -16.0784,-1.561365 -24.18796,-1.910422 -6.30881,-0.250456 -12.7802,-0.347855 -19.14933,-0.246227 z m -2.78516,15.976563 c 22.01142,-0.0212 44.05738,2.11674 65.5586,6.88086 15.15587,5.70469 31.00419,9.80057 46.0868,15.86158 9.97765,3.98727 19.68603,8.69042 28.79946,14.39782 26.91516,16.62914 49.27523,40.06629 66.22509,66.66944 13.60994,21.39974 23.91708,44.99598 29.55893,69.75277 3.5005,15.52874 5.11887,31.61746 3.38042,47.49072 -1.30558,11.77622 -4.65093,23.52131 -11.13142,33.53386 -3.87304,6.16464 -8.70993,11.78852 -14.61975,16.08381 -7.24661,5.35452 -15.86447,8.561 -24.6438,10.33962 -11.36948,2.35005 -23.01933,2.68382 -34.58416,3.10436 -8.39412,0.25285 -16.75448,0.45163 -25.12626,0.81289 -2.35032,-0.1988 -4.62153,-0.87812 -6.94141,-1.26757 -11.91802,70.81715 -23.84083,141.63351 -35.75586,212.45117 C 257.03972,578.85478 167.92696,561.46809 78.814453,544.08008 86.572852,471.39223 94.338443,398.70514 102.09961,326.01758 90.062475,318.05005 78.664241,309.05442 68.472181,298.81598 57.780479,288.02207 48.435058,275.63001 42.580078,261.5293 c -4.688952,-11.3065 -6.91634,-23.72013 -5.76605,-35.94351 1.096879,-12.46303 5.502571,-24.49197 11.98387,-35.14434 8.191491,-13.55127 19.432953,-25.0311 31.799253,-34.81853 14.653674,-11.56755 31.028129,-20.81816 48.051649,-28.40888 25.55234,-11.33689 52.71836,-18.84486 80.31409,-23.14177 16.66709,-2.55827 33.51977,-3.88621 50.38281,-3.94141 z m 170.24414,29.75781 c 5.83538,1.23411 11.6786,2.44105 17.44602,3.96948 28.12767,7.03549 56.26627,14.08001 84.39734,21.06622 26.3744,6.80324 51.79901,18.21934 73.2767,35.12011 19.32031,15.17399 35.23969,34.76275 45.65228,57.04532 9.13799,19.44119 14.30874,40.85877 14.20515,62.38048 -0.0855,11.35071 -1.66973,22.8178 -5.81407,33.43482 -2.74317,6.9256 -6.78241,13.58817 -12.78044,18.15695 -6.45277,4.94033 -14.28903,7.55977 -22.02288,9.73233 -12.42135,3.4241 -25.17685,5.38072 -37.87614,7.44327 -1.92241,0.27212 -3.84665,0.66549 -5.79697,0.47925 -28.10985,-0.76107 -56.2197,-1.52238 -84.32956,-2.28331 2.97064,-4.17931 6.02273,-8.31596 8.59375,-12.75976 0.76431,-1.32807 1.59536,-2.87683 2.27864,-4.34484 1.97888,-4.13921 3.62477,-8.56398 4.86589,-12.90126 1.65129,-5.74777 2.73366,-11.60171 3.38476,-17.57812 0.26904,-2.47469 0.45129,-4.87195 0.58789,-7.3418 0.0377,-0.9551 0.0965,-2.16084 0.12033,-3.15445 0.46673,-18.03892 -2.30486,-36.04272 -6.82306,-53.50657 -4.33107,-16.60579 -10.3367,-32.75764 -17.61563,-48.2921 -3.43229,-7.29651 -7.24406,-14.61831 -11.274,-21.59324 -2.40722,-4.17398 -4.93064,-8.28668 -7.5322,-12.28134 -9.94083,-15.28089 -21.45257,-29.70631 -35.18026,-41.82319 -4.42625,-3.95688 -8.70118,-8.08077 -13.07018,-12.10106 1.76888,0.3776 3.53776,0.75521 5.30664,1.13281 z m 138.83985,264.58008 c -8.78862,50.55711 -17.58254,101.11343 -26.375,151.66992 -59.98976,16.29297 -119.97925,32.58693 -179.96875,48.88086 11.12333,-64.5057 22.24644,-129.01143 33.36718,-193.51758 57.76573,-2.95894 115.5312,-5.92302 173.29688,-8.88281 -0.10677,0.61654 -0.21354,1.23307 -0.32031,1.84961 z',
            $this->frameId()
        );
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-16.5%%, -4%%) scale(2.2);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
