<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class CarShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'car';

    protected function symbolPath()
    {
        return 'm 587.2054,373.65094 c 0,24.64699 -19.97998,44.62696 -44.63185,44.62696 -24.64699,0 -44.62696,-19.97997 -44.62696,-44.62696 0,-24.64698 19.97997,-44.63185 44.62696,-44.63185 24.65187,0 44.63185,19.98487 44.63185,44.63185 m -396.40208,0 c 0,24.64699 -19.97999,44.62696 -44.62696,44.62696 -24.64698,0 -44.63185,-19.97997 -44.63185,-44.62696 0,-24.64698 19.98487,-44.63185 44.63185,-44.63185 24.64697,0 44.62696,19.98487 44.62696,44.63185 m 497.22343,-64.5984 c -1.19661,-1.70668 -2.0977,-3.59936 -2.66974,-5.60163 -3.74714,-8.22851 -8.04251,-16.19537 -12.84767,-23.85124 -3.23223,-3.54687 -7.36566,-6.14521 -11.96137,-7.51822 -22.32082,-7.94721 -45.48129,-13.31023 -69.02743,-15.994 -23.44117,-3.27995 -47.09227,-5.53498 -70.60057,-8.40487 -3.16561,-0.49103 -6.21673,-1.53032 -9.01986,-3.07491 -32.59944,-16.9484 -64.99872,-34.1726 -97.73117,-50.98675 h -0.004 c -15.00786,-6.45031 -31.10194,-10.02099 -47.43034,-10.52636 -9.22489,-0.88674 -18.45442,-1.57329 -27.67979,-2.32167 h -99.0334 c -12.02814,1.29673 -24.05629,2.73173 -36.15582,3.82818 -27.29292,3.5088 -53.75715,11.7898 -78.18446,24.46636 -9.56808,4.50992 -19.4076,8.6099 -28.637842,13.66782 -13.32976,7.28938 -28.098421,11.56096 -43.263729,12.50472 -6.836476,0.54826 -13.667817,1.7782 -20.914848,2.45994 l 0.0047,0.004 c -5.005796,0 -9.344007,3.46108 -10.459621,8.33811 -2.049989,10.38812 -3.484993,20.84284 -4.85324,31.3021 v -0.004 c -0.209771,3.78058 -0.209771,7.57056 0,11.34639 0.643593,4.65772 -0.810452,9.36318 -3.961702,12.84768 -2.517178,3.31814 -3.8186659,7.39422 -3.6899091,11.55131 0,6.22149 1.2967291,12.4376 1.3682471,18.72658 h -0.0047 c -0.405226,2.85085 -1.258528,5.62078 -2.5266972,8.20471 v 1.16323 -0.004 c 6.8888292,11.17467 18.8120122,18.27379 31.9172022,19.00238 h 0.75325 c 5.811416,2.80327 24.537138,5.46823 52.832048,7.65638 l -0.0041,-0.004 c 2.026186,-17.749 12.986801,-33.22919 29.052801,-41.03762 16.066,-7.81368 35.01226,-6.86503 50.21907,2.5029 15.20802,9.37268 24.57132,25.86743 24.81907,43.73116 47.09228,1.43499 101.76477,2.32165 160.13521,2.32165 47.02027,0 91.65334,-0.54824 131.83299,-1.50176 -0.0668,-18.23108 9.37744,-35.17336 24.91913,-44.70385 15.53633,-9.53 34.92074,-10.26899 51.1393,-1.94516 16.21855,8.32383 26.92189,24.50419 28.23753,42.6828 45.85719,-2.73174 75.72525,-6.22149 82.01301,-10.04491 l 11.96138,-4.99141 c 1.01546,-0.98208 1.58281,-2.34082 1.57329,-3.75666 0.81999,-9.42993 1.50175,-18.8645 2.11675,-28.29491 1.14894,-5.00579 -0.46721,-10.24506 -4.2335,-13.73982 z M 29.862606,242.34764 c 13.124715,6.0832 17.701408,17.08629 13.667816,42.98789 l -22.077935,0.004 c -2.664974,-16.81388 1.439764,-37.65672 8.409632,-42.99252 z M 450.31975,231.48282 c -13.66781,0.88673 -18.04434,8.88634 -11.41315,20.50478 -0.47198,0.24314 -0.97731,0.40522 -1.50653,0.47673 -27.33562,-1.09173 -54.67737,-2.32166 -82.35594,-3.2132 h 0.004 c -7.64684,0.41952 -14.47331,-4.7578 -16.13312,-12.23257 -4.85324,-15.3081 -10.52638,-30.34404 -15.994,-45.85719 47.29732,-1.57327 90.42312,8.19996 127.40276,40.32245 z M 216.10203,195.87498 c 15.17506,-1.64004 30.139,-3.62327 45.17616,-4.71497 12.64751,-1.0965 25.42928,-0.4815 38.07193,-1.0965 1.36825,-0.31464 2.80325,0.019 3.89494,0.89627 1.09173,0.88197 1.72108,2.21206 1.70668,3.61838 2.32167,14.35494 5.05815,28.70498 7.58485,43.05869 1.22996,6.83647 -1.02499,9.97816 -8.40487,9.77313 -25.9724,-0.82 -51.87399,-1.77821 -77.84639,-2.66499 -2.73173,0 -5.12491,0 -5.53497,-3.9617 -1.43502,-13.66781 -3.14169,-27.33564 -4.64821,-40.66538 -0.1335,-0.82475 0,-1.92123 0,-4.24302 z m -40.39446,47.1594 h 0.004 c -7.57534,0.16686 -14.05959,-5.40147 -15.03594,-12.91968 -0.98209,-5.76859 2.16909,-11.44648 7.58484,-13.66782 6.38357,-4.03322 13.02952,-7.6421 19.88967,-10.79817 7.24642,-3.2132 14.89804,-5.32995 23.23615,-8.27136 l 5.67313,46.67732 v 0.004 c -1.46832,0.22407 -2.9558,0.36232 -4.44317,0.40999 -12.0949,-0.47672 -24.39922,-0.81996 -36.69892,-1.43499 z m 455.59391,60.6893 c 3.55174,-16.40406 8.54313,-19.88966 28.49992,-20.50476 5.12492,0 14.69301,10.79815 17.49638,20.50476 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(0%%, -3.5%%) scale(1.6);
        }
        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId());
    }

    protected function frameStrokeWidth()
    {
        return 3;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            -$this->output->size * 4,
            $this->output->size * 10
        );
    }
}
