<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class CookingShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'cooking';

    protected function symbolPath()
    {
        return 'm 98.826371,524.72948 c 0,60.28292 48.922999,109.20593 109.205919,109.20593 h 283.93542 c 60.28292,0 109.20592,-48.92301 109.20592,-109.20593 V 328.1588 H 98.826371 Z m 32.761759,-152.8883 c 0,-6.00632 4.91428,-10.92059 10.92061,-10.92059 6.00632,0 10.92059,4.91427 10.92059,10.92059 v 152.8883 c 0,30.13834 24.46462,54.60297 54.60296,54.60297 6.00633,0 10.92059,4.91426 10.92059,10.92058 0,6.00633 -4.91426,10.9206 -10.92059,10.9206 -42.15099,0 -76.44416,-34.29316 -76.44416,-76.44415 z M 513.80889,175.2705 H 186.1911 c -40.73318,0 -74.80668,27.84689 -84.52788,65.52356 H 598.33179 C 588.61532,203.11739 554.54208,175.2705 513.80889,175.2705 Z M 666.6972,350 h -43.68238 v 43.68237 h 21.84119 v 43.68237 c 0,12.01265 9.82852,21.84118 21.84119,21.84118 12.01265,0 21.84117,-9.82853 21.84117,-21.84118 V 371.84118 C 688.53837,359.82852 678.70985,350 666.6972,350 Z M 11.461628,371.84118 v 65.52356 c 0,12.01265 9.828533,21.84118 21.841185,21.84118 12.012654,0 21.841182,-9.82853 21.841182,-21.84118 V 393.68237 H 76.985184 V 350 H 33.302813 c -12.012652,0 -21.841185,9.82852 -21.841185,21.84118 z M 633.93541,284.47644 c 0,-12.01266 -9.82853,-21.84119 -21.84119,-21.84119 H 87.905778 c -12.012651,0 -21.841189,9.82853 -21.841189,21.84119 0,12.01265 9.828538,21.84119 21.841189,21.84119 H 612.09422 c 12.01266,0 21.84119,-9.82854 21.84119,-21.84119 z M 350,153.42933 c 24.13264,0 43.68237,-19.54974 43.68237,-43.68237 0,-24.132638 -19.54973,-43.682371 -43.68237,-43.682371 -24.13264,0 -43.68237,19.549733 -43.68237,43.682371 0,24.13263 19.54973,43.68237 43.68237,43.68237 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function renderStyles()
    {
        return sprintf('.foreground-0 {
            transform: translate(0%%, 16%%) scale(2.4);
        }

        #%2$s path {
            transform: scale(1);
        }
        
        #%3$s {
            fill: none;
        }

        .foreground-1 {
            mask: url(#%s);
        }', $this->maskId(), $this->symbolId(), $this->frameId());
    }

    protected function frameStrokeWidth()
    {
        return 7;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
