<?php

namespace App\Support\QRCodeProcessors\ShapeProcessors;

class DentistShapeProcessor extends BaseShapeProcessor
{
    protected static $shapeId = 'dentist';

    protected function symbolPath()
    {
        return 'M 210.89843,885.32291 C 161.62316,867.73829 138.06343,803.58066 131.16629,668.19703 125.12624,549.63721 124.30808,545.36255 93.388096,470.81624 70.068558,414.59418 64.275466,392.44329 64.275466,359.49906 c 0,-48.61625 15.243199,-85.5664 49.486344,-119.95694 24.7113,-24.81768 48.33025,-38.51273 80.69687,-46.79071 39.83383,-10.18778 66.04984,-6.5537 118.80042,16.46821 38.65184,16.86879 54.78265,21.1008 80.42813,21.1008 25.74291,0 44.27969,-4.86724 81.80909,-21.48079 41.67806,-18.45008 58.55739,-22.38855 88.25308,-20.59217 43.36811,2.62346 76.87038,18.22414 110.10163,51.26997 17.53582,17.43798 23.80653,25.98941 32.53321,44.36588 13.82967,29.12221 17.80945,46.39226 17.58906,76.32712 -0.23969,32.54598 -5.64314,53.07268 -28.15603,106.95767 -32.2771,77.25587 -32.02474,75.91154 -39.62962,211.11761 -5.55027,98.67714 -20.34225,154.83057 -48.96556,185.8832 -12.61492,13.68556 -26.04839,21.37449 -41.72295,23.88094 -9.44541,1.51039 -11.63048,0.82275 -17.49554,-5.50576 -9.87194,-10.652 -20.55588,-38.52449 -40.07294,-104.54313 -25.13709,-85.02911 -40.9815,-118.98707 -66.11096,-141.69005 -14.70162,-13.28199 -27.67351,-18.1967 -48.3855,-18.33192 -44.81784,-0.29262 -75.27174,36.9987 -103.05736,126.1955 -6.71318,21.55052 -17.05808,54.8499 -22.98865,73.99863 -20.65446,66.68949 -29.22646,76.87908 -56.48976,67.14979 z M 178.14706,502.45093 c 3.97059,-6.05989 3.4484,-8.18617 -9.9229,-40.405 -7.76272,-18.70467 -16.24936,-35.15129 -18.8592,-36.54803 -6.64303,-3.55524 -15.45774,1.72714 -15.45774,9.26334 0,8.16577 25.20699,68.76502 29.81901,71.68688 6.05211,3.83416 10.00798,2.73768 14.42083,-3.99719 z M 129.0707,371.59254 c 2.67533,-2.12147 4.71959,-9.34476 5.58103,-19.72029 3.11672,-37.53854 26.74171,-66.18911 63.60619,-77.13668 7.85822,-2.33364 17.64202,-4.24298 21.74178,-4.24298 9.50589,0 14.55079,-8.1649 10.13871,-16.40896 -2.76831,-5.17263 -4.72252,-5.57661 -21.25412,-4.39378 -35.44701,2.53622 -70.45615,26.36677 -86.24293,58.70514 -7.75627,15.88832 -14.00008,46.79379 -11.09421,54.9139 2.54914,7.12323 6.4732,11.63133 10.12447,11.63133 1.74758,0 5.07717,-1.50646 7.39908,-3.34768 z';
    }

    protected function symbolViewBox()
    {
        return '0 0 700 700';
    }

    protected function frameNode()
    {
        return $this->makeSinglePathUsedSymbol(
            'symbol-frame-' . $this::$shapeId,
            '0 0 700 700',
            'm 506.79297,16.673828 c -4.07219,-0.04675 -7.72564,3.754106 -7.46989,7.831541 -0.0379,6.535911 -0.01,13.072722 -0.0226,19.609084 0.004,15.378164 -0.0324,30.758428 0.0751,46.135176 0.48773,4.030854 4.6598,7.264813 8.69867,6.483324 3.30191,-0.465792 6.17003,-3.279253 6.44331,-6.647015 0.23096,-2.41734 -0.0139,-4.848573 0.0783,-7.272266 -0.008,-19.832755 0.0388,-39.667402 -0.0626,-59.498925 -0.41899,-3.711483 -3.9783,-6.855779 -7.74027,-6.640919 z M 620.37695,60.125 c -2.60189,0.177654 -4.76661,1.896021 -6.39965,3.805856 -15.97911,15.991746 -32.00177,31.942566 -47.91239,48.001084 -2.60251,3.22414 -1.90674,8.60111 1.60814,10.89325 2.66334,1.92187 6.59446,1.92872 9.14112,-0.20963 1.8365,-1.49604 3.33464,-3.35372 5.07315,-4.9577 15.04407,-15.05172 30.12414,-30.069639 45.10129,-45.186826 2.56239,-3.123558 2.01897,-8.334362 -1.30393,-10.716291 -1.49245,-1.164959 -3.41518,-1.776488 -5.30773,-1.629743 z m -446.57812,63.94141 c -17.97847,0.29062 -36.04183,3.93713 -52.71089,10.83497 -7.83447,3.21615 -15.46729,7.18833 -22.562549,11.69042 -6.709382,4.27433 -12.991596,9.02352 -18.931641,14.32617 -11.698647,10.45528 -21.807599,22.86961 -29.592171,36.55327 -8.841642,15.44826 -14.830371,32.72798 -17.437815,50.40738 -0.701036,4.71973 -1.146469,9.43235 -1.387983,14.22685 -0.267424,5.59749 -0.212546,11.35442 0.144919,16.90796 0.2892,4.6486 0.812388,9.36649 1.513312,13.84568 1.996506,13.0191 5.689245,25.81333 10.249972,38.09597 8.812442,23.7534 20.723782,46.28744 28.365231,70.48509 4.534274,14.40316 7.409104,29.47661 7.781254,44.5403 0.936121,22.50119 1.552243,45.01853 2.951172,67.49805 1.048037,16.51259 2.462936,33.06841 4.786538,49.49606 2.301315,16.27069 5.413507,32.47137 10.24743,48.20283 0.868212,2.80679 1.773125,5.53211 2.74668,8.25841 4.865211,13.58235 11.260101,26.81719 20.525941,37.973 3.86892,4.67542 8.47332,9.12311 13.34771,12.70837 9.12382,6.76179 20.01192,10.97062 31.21908,12.6244 4.49817,0.75313 9.19614,0.92306 13.602,-0.42895 6.22681,-1.83019 11.32287,-6.25743 15.27012,-11.27634 4.52506,-5.75942 7.91896,-12.31026 10.93345,-18.9581 4.19715,-9.45131 7.46398,-19.19764 10.55722,-29.05573 7.85369,-25.21199 14.14926,-50.90572 22.91791,-75.82943 4.08017,-11.45023 8.55438,-22.80769 14.32628,-33.52435 4.13038,-7.56551 8.89372,-14.87293 14.89727,-21.09539 5.72243,-5.8749 12.82226,-10.67271 20.87992,-12.58628 5.62012,-1.35861 11.6143,-1.13186 17.09055,0.74372 7.93009,2.57528 14.71402,7.87212 20.12904,14.11158 7.71317,8.78527 13.23083,19.22082 18.04976,29.80129 7.09688,15.77285 12.3166,32.29975 17.31505,48.83177 6.07118,20.38308 11.4008,40.99746 18.26016,61.13926 3.71253,10.77168 7.93066,21.47118 13.97992,31.17052 3.68919,5.77354 8.26106,11.26115 14.34613,14.6049 5.4984,3.05281 12.09818,3.50308 18.19185,2.35022 2.26469,-0.32761 4.51182,-0.76981 6.73741,-1.30083 0.77376,-0.19468 1.84058,-0.45388 2.71634,-0.71487 8.30196,-2.33255 16.18398,-6.20559 23.00632,-11.49216 1.27095,-0.98952 2.68563,-2.14436 3.94591,-3.27818 10.20818,-9.0868 17.68627,-20.83375 23.35502,-33.1751 6.86814,-15.0468 11.31901,-31.13479 14.58294,-47.27311 2.00635,-9.99095 3.5692,-20.06754 4.83488,-30.17791 4.58863,-36.99304 5.23933,-74.42659 6.81656,-111.71825 0.67497,-17.48941 4.73907,-34.71022 10.71066,-51.11499 7.66008,-21.26419 17.98741,-41.44346 25.75012,-62.66871 1.37817,-3.79369 2.71777,-7.72907 3.90787,-11.59012 2.96749,-9.608 5.27549,-19.61171 6.5249,-29.66201 1.45548,-11.45076 1.62496,-23.06865 0.44419,-34.55256 -1.03199,-9.91805 -3.15027,-19.95201 -6.26686,-29.53491 -9.70754,-30.17761 -29.73098,-56.86348 -55.83807,-74.81447 -2.67241,-1.85013 -5.37845,-3.58614 -8.12418,-5.23235 -3.84503,-2.29126 -7.8292,-4.41928 -11.81021,-6.31921 -5.53418,-2.63631 -11.23458,-4.92186 -17.05639,-6.84124 -1.76943,-0.57637 -3.74361,-1.1943 -5.61309,-1.71906 -2.75481,-0.78645 -5.75119,-1.54409 -8.54758,-2.15395 -7.19612,-1.59156 -14.55532,-2.59465 -21.8577,-3.06386 -6.61382,-0.41478 -13.26068,-0.40105 -19.86444,0.1771 -3.76564,0.33797 -7.82181,0.90103 -11.63645,1.61927 -11.79644,2.24831 -23.13514,6.46806 -34.06765,11.47597 -12.92014,5.85159 -25.56718,12.57864 -39.32951,16.29485 -16.83323,4.55377 -34.97278,4.11945 -51.56639,-1.24804 -15.33322,-4.85418 -29.30957,-13.01394 -44.1971,-18.97527 -5.91325,-2.38146 -11.95998,-4.44809 -18.1404,-6.02029 -1.10929,-0.27208 -2.47028,-0.60693 -3.68592,-0.86023 -2.55731,-0.56848 -5.1386,-1.06251 -7.66222,-1.43922 -3.10726,-0.47343 -6.11736,-0.79532 -9.22803,-1.02087 -3.51082,-0.24586 -7.25118,-0.3404 -10.84375,-0.27929 z m 240.29687,15.28515 c 26.69438,-0.18322 53.39131,8.13661 75.19181,23.55833 22.31866,15.67837 39.60397,38.47996 48.38299,64.32727 6.61621,19.30936 8.5227,40.1792 5.70999,60.38635 -2.04685,15.36106 -6.66809,30.26144 -12.41868,44.6125 -5.25838,13.27553 -11.27184,26.23258 -16.75087,39.41633 -4.68993,11.29482 -8.9965,22.98417 -12.11812,34.90431 -1.12668,4.30731 -2.0949,8.59441 -2.9113,12.99807 -0.34075,1.85481 -0.68329,3.86249 -0.95981,5.72956 -0.97748,6.42742 -1.56846,13.05756 -1.79491,19.61328 -1.3762,32.75313 -2.02931,65.57458 -5.42861,98.20215 -1.95737,18.43893 -4.62859,36.86328 -9.35873,54.81726 -3.58032,13.3405 -8.20768,26.53813 -15.33282,38.43264 -5.5703,9.26047 -12.81506,17.72921 -22.03571,23.50969 -5.72804,3.65664 -12.16266,6.16675 -18.83894,7.421 -2.33236,0.42778 -4.71426,0.80414 -7.08917,0.67371 -4.26183,-0.48707 -7.76638,-3.46386 -10.21332,-6.81768 -5.04209,-6.8813 -8.1089,-14.92176 -11.1888,-22.80607 -6.4994,-17.2727 -11.36611,-35.09388 -16.50168,-52.8037 -6.1345,-21.36691 -12.31864,-42.79681 -20.9859,-63.3039 -1.81549,-4.25029 -3.67777,-8.34565 -5.77423,-12.49415 -2.48227,-4.96028 -5.31992,-9.95066 -8.29608,-14.47851 -1.90889,-2.89967 -4.05163,-5.85648 -6.16406,-8.46484 -6.63456,-8.21382 -14.92963,-15.3786 -24.81836,-19.32813 -5.21831,-2.07483 -10.7697,-3.31576 -16.38086,-3.59375 -1.6512,-0.0873 -3.52331,-0.0896 -5.25781,0 -7.42361,0.38836 -14.9572,2.51249 -21.56441,6.09827 -9.57669,5.2145 -17.27665,13.29015 -23.50543,22.13294 -8.9332,12.71886 -15.26722,27.03278 -20.76592,41.5072 -10.93155,29.11015 -17.94836,59.44482 -27.48984,89.01675 -3.06588,9.34053 -6.33787,18.63809 -10.45614,27.57352 -2.18732,4.61991 -4.67113,9.18441 -8.10434,13.00695 -2.66658,2.86636 -6.43573,5.08805 -10.46966,4.76057 -2.9266,-0.17726 -5.79951,-0.84625 -8.64411,-1.52124 -10.94294,-2.86085 -20.79804,-9.32019 -28.19558,-17.82814 -8.69169,-9.79224 -14.57025,-21.72428 -19.04752,-33.93794 -6.16133,-16.92941 -9.63205,-34.69389 -12.23585,-52.47712 C 98.417463,535.06387 96.989196,507.66341 95.878906,480.30273 95.326221,466.4526 94.889133,452.59678 94.202844,438.75267 93.40548,426.90331 91.258629,415.13348 88.096166,403.73384 81.524285,379.92227 70.360093,357.78025 61.069804,334.98618 54.433039,318.68169 48.993518,301.70731 47.11927,284.1363 44.561835,261.06099 48.059894,237.26283 57.677755,216.09536 68.309556,192.43917 86.170326,172.0867 108.2931,158.53992 c 17.90977,-11.02564 38.53382,-17.62298 59.53155,-18.91963 12.10206,-0.81604 24.36813,0.22419 36.05804,3.52615 14.35306,3.97999 27.57326,11.04889 41.07275,17.11955 6.84055,3.08882 13.92116,5.90251 21.09339,7.94104 3.01688,0.86131 6.06647,1.60973 9.14648,2.20899 0.60026,0.10426 1.6453,0.29957 2.24133,0.4064 1.77428,0.28974 3.41725,0.54074 5.22864,0.75185 1.40395,0.17367 2.74903,0.30609 4.21232,0.42311 4.27051,0.35561 8.57806,0.4274 12.81967,0.2702 3.87811,-0.16139 7.92286,-0.51862 11.84285,-1.12735 1.77277,-0.27827 3.5038,-0.5835 5.19295,-0.93757 2.91651,-0.59383 5.93786,-1.35258 8.7142,-2.15383 13.8891,-3.99944 26.7165,-10.78605 39.83147,-16.7106 9.77246,-4.42788 19.89342,-8.28345 30.48491,-10.20636 6.04065,-1.14188 12.18495,-1.7332 18.33205,-1.78031 z m 246.57032,30.43164 c -23.12082,0.01 -46.24336,-0.0418 -69.36305,0.06 -4.11494,0.43399 -7.43361,4.71526 -6.57575,8.81986 0.50942,3.21352 3.22688,5.99588 6.50868,6.31647 2.42109,0.27196 4.86203,0.002 7.29183,0.0988 21.26788,-0.006 42.53728,0.0411 63.80414,-0.0614 4.08712,-0.43415 7.38496,-4.66519 6.57143,-8.74694 -0.46984,-3.19225 -3.12101,-5.93591 -6.33885,-6.38127 -0.62701,-0.10175 -1.26401,-0.13569 -1.89843,-0.10547 z m -496.21875,17.25586 c -1.76909,0.03 -3.433,0.0854 -5.22266,0.21485 -1.83214,0.13446 -3.91414,0.3597 -5.87579,0.65325 -16.13392,2.38702 -31.49544,9.77801 -43.37182,20.96602 -11.167443,10.43246 -19.376479,24.0331 -23.183139,38.84877 -1.233755,4.74048 -2.013548,9.59549 -2.379799,14.47922 -0.02438,0.46988 -0.08666,1.39383 -0.113297,1.85188 -0.108516,3.32523 -0.251328,6.68418 0.236344,9.98601 0.859894,3.87235 5.152782,6.59239 9.019884,5.60702 3.164837,-0.69574 5.823109,-3.5165 5.977702,-6.81088 0.118199,-2.31042 -0.151816,-4.56811 -0.01527,-6.89696 0.513005,-16.17384 7.223435,-32.09141 18.578635,-43.6416 10.8579,-11.19124 25.77429,-18.43265 41.34337,-19.70387 2.4891,-0.23592 5.00094,-0.20854 7.4863,-0.44043 3.81321,-0.8254 6.68908,-4.89797 5.84853,-8.7774 -0.52192,-3.07644 -3.0509,-5.72694 -6.16407,-6.20776 -0.71191,-0.13586 -1.44201,-0.17079 -2.16492,-0.12812 z m -56.78516,132.125 c -4.0113,0.17855 -7.50522,3.97376 -7.1582,8.01563 0.17285,2.57758 1.63952,4.79382 2.54523,7.14981 5.95541,13.61097 11.87702,27.24555 17.16295,41.13256 1.44765,3.49015 5.72652,5.43295 9.30549,4.21177 3.00276,-0.94402 5.30218,-3.84748 5.32226,-7.02735 0.0752,-2.62298 -1.35128,-4.92142 -2.16028,-7.33179 -5.55253,-14.25783 -11.71931,-28.26648 -17.88742,-42.26477 -1.37119,-2.51576 -4.28473,-4.05695 -7.13003,-3.88586 z',
            $this->frameId()
        );
    }

    protected function renderStyles()
    {
        return sprintf(
            '.foreground-0 {
            transform: translate(-6.5%%, -8%%) scale(2.4);
        }

        #%2$s path {
            transform: scale(0.75);
        }
        
        #%3$s {
            fill: %4$s;
        }

        .foreground-1 {
            mask: url(#%s);
        }',
            $this->maskId(),
            $this->symbolId(),
            $this->frameId(),
            $this->qrcode->design->frameColor
        );
    }

    protected function frameStrokeWidth()
    {
        return 7;
    }

    protected function modifiedViewBox()
    {
        return sprintf(
            '%1$s %1$s %2$s %2$s',
            $this->output->size * -2,
            $this->output->size * 6
        );
    }
}
